# 分页

我们有如下订单表：

```sql
create table orders
(
    id          serial primary key,
    product_id  integer,
    order_date  date default now(),
    quantity    integer,
    customer_id integer
);
```

现在开发人员希望查询指定的某一天内的数据，并按每一百条一页查询，那么正确的语句应该是：

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
select id, product_id, order_date, quantity, customer_id
from orders
where date = $1
offset $2 limit 100; 
```

## 选项

### 缺少 limit

```sql
select id, product_id, order_date, quantity, customer_id
from orders
where date = $1
offset $2; 
```

### 缺少 offset

```sql
select id, product_id, order_date, quantity, customer_id
from orders
where date = $1; 
```

### 结构不对

```sql
select id, product_id, order_date, quantity, customer_id
from orders
where date = $1 and
offset $2 and limit 100; 
```
